/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import org.havi.ui.HChangeData;
import org.havi.ui.HExtendedLook;
import org.havi.ui.HVisible;
import org.videolan.Logger;

public class HTextLook
implements HExtendedLook {
    private static final Logger logger = Logger.getLogger(HTextLook.class.getName());

    public void fillBackground(Graphics g, HVisible visible, int state) {
        if (visible.getBackgroundMode() == 1) {
            Color color = visible.getBackground();
            Dimension dimension = visible.getSize();
            g.setColor(color);
            g.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    public void renderBorders(Graphics g, HVisible visible, int state) {
        Insets insets = this.getInsets(visible);
        Color fg = visible.getForeground();
        Dimension dimension = visible.getSize();
        if (fg != null) {
            g.setColor(fg);
            g.fillRect(0, 0, dimension.width, insets.top);
            g.fillRect(dimension.width - insets.right, 0, insets.right, dimension.height);
            g.fillRect(0, dimension.height - insets.bottom, dimension.width, insets.bottom);
            g.fillRect(0, 0, insets.left, dimension.height);
        }
    }

    public void renderVisible(Graphics g, HVisible visible, int state) {
        String text = visible.getTextContent(state);
        if (text == null) {
            return;
        }
        logger.unimplemented("renderVisible[text=" + text + "]");
    }

    public void showLook(Graphics g, HVisible visible, int state) {
        this.fillBackground(g, visible, state);
        this.renderVisible(g, visible, state);
        this.renderBorders(g, visible, state);
    }

    public void widgetChanged(HVisible visible, HChangeData[] changes) {
        visible.repaint();
    }

    public Dimension getMinimumSize(HVisible hvisible) {
        logger.unimplemented("getMinimumSize");
        return null;
    }

    public Dimension getPreferredSize(HVisible hvisible) {
        logger.unimplemented("getPreferredSize");
        return null;
    }

    public Dimension getMaximumSize(HVisible hvisible) {
        logger.unimplemented("getMAximumSize");
        return null;
    }

    public boolean isOpaque(HVisible visible) {
        if (visible.getBackgroundMode() != 1) {
            return false;
        }
        Color bg = visible.getBackground();
        return bg != null && bg.getAlpha() >= 255;
    }

    public Insets getInsets(HVisible visible) {
        if (!visible.getBordersEnabled()) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(2, 2, 2, 2);
    }
}

